/**
 * JPFContext.java
 * Created Feb 12, 2010
 */
package com.tandbergtv.watchpoint.studio.external.jpf;

import com.tandbergtv.watchpoint.studio.dataaccess.IPersistenceContext;

/**
 * Persistence context for loading data from JPF
 * 
 * @author Sahil Verma
 */
public class JPFContext implements IPersistenceContext {

	private JPFPluginManager pluginManager;
	
	/**
	 * @param path
	 */
	public JPFContext(String path) {
		super();
		this.pluginManager = new JPFPluginManagerImpl(path);
	}

	/**
	 * @return the pluginManager
	 */
	public JPFPluginManager getPluginManager() {
		return pluginManager;
	}

	/**
	 * {@inheritDoc}
	 */
	public void initialize() {
		this.pluginManager.initialize();
	}
	
	/**
	 * {@inheritDoc}
	 */
	public void close() {
		this.pluginManager.close();
	}

	/**
	 * {@inheritDoc}
	 */
	public void beginTransaction() {
	}
	
	/**
	 * {@inheritDoc}
	 */
	public void commitTransaction() {
	}

	/**
	 * {@inheritDoc}
	 */
	public Object getCurrentTransaction() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public void rollbackTransaction() {
	}
}
