/*
 * Created on Mar 20, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.external.jpf.model;

/**
 * Contains the details of a single message.
 * 
 * @author Vijay Silva
 */
public class MessageDescriptor implements WatchPointDescriptor
{
	private static final long serialVersionUID = 2958341540028027242L;

	/* The Message Name */
	private String name;

	/* The Message UID */
	private String uid;

	/* A Description of the Message */
	private String description;

	/* The Protocol used when sending / receiving message */
	private String protocol;

	/**
	 * Default Constructor
	 */
	public MessageDescriptor()
	{
	}

	/**
	 * @param name
	 *            The Message Name
	 * @param uid
	 *            The Message UID
	 */
	public MessageDescriptor(String name, String uid)
	{
		this.name = name;
		this.uid = uid;
	}

	/**
	 * @return the description
	 */
	public String getDescription()
	{
		return this.description;
	}

	/**
	 * @param description
	 *            the description to set
	 */
	public void setDescription(String description)
	{
		this.description = description;
	}

	/**
	 * @return the name
	 */
	public String getName()
	{
		return this.name;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name)
	{
		this.name = name;
	}

	/**
	 * @return the protocol
	 */
	public String getProtocol()
	{
		return this.protocol;
	}

	/**
	 * @param protocol
	 *            the protocol to set
	 */
	public void setProtocol(String protocol)
	{
		this.protocol = protocol;
	}

	/**
	 * @return the uid
	 */
	public String getUID()
	{
		return this.uid;
	}

	/**
	 * @param uid
	 *            the uid to set
	 */
	public void setUID(String uid)
	{
		this.uid = uid;
	}

	/**
	 * Creates a clone of the
	 * 
	 * @see java.lang.Object#clone()
	 */
	@Override
	public Object clone()
	{
		MessageDescriptor clone = null;

		try
		{
			clone = (MessageDescriptor) super.clone();
		}
		catch (CloneNotSupportedException ex)
		{ // Should never happen
		}

		return clone;
	}
}
