package com.tandbergtv.watchpoint.studio.external.wpexport.impl;

import java.io.ByteArrayInputStream;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;

import com.tandbergtv.watchpoint.studio.docgeneration.resourcetype.GenerateDoc;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;

public class ResourceTypeDocumentExporter {
    private static final Logger logger = Logger.getLogger(ResourceTypeDocumentExporter.class);

    public static final String RESOURCES_FOLDER = "resources";
    public static final String DOC_EXTENSION = ".html";
    public static final String DOC_FOLDER = "doc";
    public static final String NODE_FOLDER = "node";

    private ResourceTypeDocumentExporter() {
	}

    public static void export(ResourceType rt) {
        try {
            IContainer project = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(rt.getPath())).getParent();
            String nodesFolder = new StringBuilder().append(RESOURCES_FOLDER).append("/").append(NODE_FOLDER)
                    .toString();
            if (!project.getFolder(new Path(nodesFolder)).exists()) {
                return;
            }
            if (!project.getFolder(new Path(ResourceTypeDocumentExporter.RESOURCES_FOLDER)).exists()) {
                project.getFolder(new Path(ResourceTypeDocumentExporter.RESOURCES_FOLDER)).create(IFolder.FORCE, true,
                        null);
            }

            String resourcesDocFolder = new StringBuilder().append(RESOURCES_FOLDER).append("/").append(DOC_FOLDER)
                    .toString();
            if (!project.getFolder(new Path(resourcesDocFolder)).exists()) {
                project.getFolder(new Path(resourcesDocFolder)).create(IFolder.FORCE, true, null);
            }

            IFile docFile = project.getFile(new Path(new StringBuilder().append(resourcesDocFolder).append("/")
                    .append(rt.getName()).append(ResourceTypeDocumentExporter.DOC_EXTENSION).toString()));
            String contentGenerated = GenerateDoc.generate(project.getLocation().toPortableString());
            if (docFile.exists()) {
                docFile.setContents(new ByteArrayInputStream(contentGenerated.getBytes()), IFile.FORCE, null);
            } else {
                docFile.create(new ByteArrayInputStream(contentGenerated.getBytes()), IFile.FORCE, null);
            }

        } catch (CoreException e) {
            logger.error(e.getMessage());
        }
    }
}
