/**
 * 
 */
package com.tandbergtv.watchpoint.studio.service;

import java.util.List;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;

/**
 * Exception indicating a delete operation has failed because that object is being referenced by
 * some other entity. The exception contains a list of IWatchPointDTO entities which reference the
 * object being deleted.
 * 
 * @author Imran Naqvi
 * 
 */
public class ReferenceDeletionException extends ServiceException {

	private static final long serialVersionUID = -8671208736018385937L;

	List<IWatchPointDTO> references;

	/**
	 * @param errorCode
	 *            The error code
	 * @param references
	 *            The list of IWatchPointDTO entities which reference the object being deleted
	 */
	public ReferenceDeletionException(ServiceErrorCode errorCode, List<IWatchPointDTO> references) {
		super(errorCode);
		this.references = references;
	}

	/**
	 * @param errorCode
	 *            The error code
	 * @param references
	 *            The list of IWatchPointDTO entities which reference the object being deleted
	 * @param cause
	 *            The Cause
	 */
	public ReferenceDeletionException(ServiceErrorCode errorCode, List<IWatchPointDTO> references,
			Throwable cause) {
		super(errorCode, cause);
		this.references = references;
	}

	/**
	 * @param errorCode
	 *            The error code
	 * @param references
	 *            The list of IWatchPointDTO entities which reference the object being deleted
	 * @param message
	 *            The detail message
	 * @param cause
	 *            The cause
	 */
	public ReferenceDeletionException(ServiceErrorCode errorCode, List<IWatchPointDTO> references,
			String message, Throwable cause) {
		super(errorCode, message, cause);
		this.references = references;
	}

	/**
	 * @param errorCode
	 *            The error code
	 * @param references
	 *            The list of IWatchPointDTO entities which reference the object being deleted
	 * @param message
	 *            The detail message
	 */
	public ReferenceDeletionException(ServiceErrorCode errorCode, List<IWatchPointDTO> references,
			String message) {
		super(errorCode, message);
		this.references = references;
	}

	/**
	 * Get the list of IWatchPointDTO entities which reference the object being deleted.
	 * 
	 * @return The list of IWatchPointDTO entities
	 */
	public synchronized List<IWatchPointDTO> getReferences() {
		return references;
	}
}
