/*
 * Created on Oct 15, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.ui.editor.input;

import org.eclipse.core.commands.common.EventManager;
import org.eclipse.jface.util.SafeRunnable;

/**
 * Interface that allows the implementer to indicate that its input has been modified.
 * 
 * @author Vijay Silva
 */
public class InputChangedEventManager extends EventManager
{
	/**
	 * Add an input changed listener to the list of existing listeners
	 * 
	 * @param listener
	 *            The input changed listener
	 */
	public void addInputChangedListener(IInputChangedListener listener)
	{
		super.addListenerObject(listener);
	}

	/**
	 * Removes the input changed listener from the list of existing listeners
	 * 
	 * @param listener
	 *            The input changed listener
	 */
	public void removeInputChangedListener(IInputChangedListener listener)
	{
		super.removeListenerObject(listener);
	}

	/**
	 * Clears all of the listeners from the listener list.
	 */
	public void removeAllListeners()
	{
		super.clearListeners();
	}

	/**
	 * Returns the listeners attached to this event manager.
	 * 
	 * @return The list of attached input changed listeners.
	 */
	public IInputChangedListener[] getAllListeners()
	{
		return (IInputChangedListener[]) super.getListeners();
	}

	/**
	 * Whether one or more listeners are attached to the manager.
	 * 
	 * @return <code>true</code> if listeners are attached to the manager; <code>false</code>
	 *         otherwise.
	 */
	public boolean isInputChangedListenerAttached()
	{
		return super.isListenerAttached();
	}

	/**
	 * Fires the Input Changed Event to all attached listeners
	 * 
	 * @param event
	 *            The Input Changed Event to fire
	 */
	public void fireInputChanged(final InputChangedEvent event)
	{
		Object[] listeners = super.getListeners();
		for (int i = 0; i < listeners.length; ++i)
		{
			final IInputChangedListener listener = (IInputChangedListener) listeners[i];
			SafeRunnable.run(new SafeRunnable()
			{
				public void run()
				{
					listener.inputChanged(event);
				}
			});
		}
	}
}
