/*
 * Created on Sep 21, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.eventhandler;

import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.widgets.Text;

/**
 * Focus Listener that attempts to trim the contents of any Text Field
 * 
 * @author Vijay Silva
 */
public class TextTrimFocusListener extends FocusAdapter
{
	/**
	 * @see org.eclipse.swt.events.FocusAdapter#focusLost(org.eclipse.swt.events.FocusEvent)
	 */
	@Override
	public void focusLost(FocusEvent e)
	{
		if (e.getSource() instanceof Text)
		{
			Text source = (Text) e.getSource();
			String value = source.getText();
			if (value != null)
			{
				String trimmedValue = value.trim();
				if (!trimmedValue.equals(value))
					source.setText(value.trim());
			}
		}
	}
}
