/**
 * ITree.java
 * Created Apr 15, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.model.tree;

/**
 * A tree model
 * 
 * @author Sahil Verma
 */
public interface ITree<T> {
	
	/**
	 * Gets the root node
	 * 
	 * @return
	 */
	ITreeNode<T> getRoot();
	
	/**
	 * Allows a visitor to traverse the tree nodes
	 * 
	 * @param visitor
	 */
	void accept(ITreeNodeVisitor<T> visitor, ITreeNode<T> node);
}
