package com.tandbergtv.watchpoint.studio.ui.properties;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.common.part.OutlineEditPart;

import com.tandbergtv.watchpoint.studio.ui.model.IResourceTypeElement;

/**
 * Property section for viewing/setting the resource group of an element.
 * 
 * @author Imran Naqvi
 *
 */
public class ResourceGroupElementSection extends AbstractPropertySection
{
	private ResourceGroupElementConfigurationComposite resourceGroupElementConfigurationComposite;
	private IResourceTypeElement resourceTypeElement;
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#createControls(org.eclipse.swt.widgets.Composite, org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage)
	 */
	public void createControls(Composite parent,
            TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite clientArea = getWidgetFactory().createFlatFormComposite(parent);
        resourceGroupElementConfigurationComposite = ResourceGroupElementConfigurationComposite.create(getWidgetFactory(), clientArea);
    }
 
 	/* (non-Javadoc)
 	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#setInput(org.eclipse.ui.IWorkbenchPart, org.eclipse.jface.viewers.ISelection)
 	 */
 	public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) return;
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof NotationElementGraphicalEditPart) {
        	AbstractNotationElement notationElement = ((NotationElementGraphicalEditPart)input).getNotationElement();
        	IResourceTypeElement nodeSelected = (IResourceTypeElement)notationElement.getSemanticElement();
        	setResourceGroupElement(nodeSelected);
        } else if (input instanceof OutlineEditPart) {
        	IResourceTypeElement nodeSelected = (IResourceTypeElement)((OutlineEditPart)input).getModel();
        	setResourceGroupElement(nodeSelected);
        }
    }
 	
 	/* (non-Javadoc)
 	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#refresh()
 	 */
 	public void refresh() {
 		if (resourceTypeElement != null) {
 			resourceGroupElementConfigurationComposite.setResourceGroupElement(resourceTypeElement);
 		}
    }
 	
 	/**
 	 * Sets the resource group element.
 	 * 
 	 * @param resourceTypeElement
 	 */
 	private void setResourceGroupElement(IResourceTypeElement resourceTypeElement) {
 		this.resourceTypeElement = resourceTypeElement;
 	}

}
