/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.properties.filter;

import org.jbpm.gd.common.model.SemanticElement;

import com.tandbergtv.watchpoint.studio.ui.model.LoopNode;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;

/**
 * Filter for nested node definitions. This filter is only for the nofe definition editor.
 * 
 * @author Imran Naqvi
 * 
 */
public class NestedNodeDefinitionFilter extends WPPropertyFilter {

	/**
	 * @see com.tandbergtv.watchpoint.studio.ui.properties.filter.WPPropertyFilter#selectModelElement(org.jbpm.gd.common.model.SemanticElement)
	 */
	@Override
	protected boolean selectModelElement(SemanticElement modelElement) {
		/*
		 * If the active container is not a node definition or a loop node, then it can not have a nested node
		 * definition
		 */
		if (this.container == null || 
				( !(this.container instanceof NodeDefinition) && !(this.container instanceof LoopNode) ) )
			return false;
		
		if(this.container instanceof NodeDefinition){
			NodeDefinition root = (NodeDefinition) this.container;
			/*
			 * This model is a nested node definition if it is of type NodeDefinition and its name is
			 * not that of the node definition being edited in the active editor
			 */
			return modelElement instanceof NodeDefinition
					&& !root.getName().equals(((NodeDefinition) modelElement).getName());
		} else if(this.container instanceof LoopNode){
			return modelElement instanceof NodeDefinition;
		}
		
		return false;
	}
}
