package com.tandbergtv.watchpoint.studio.ui.view.resourcetype.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.editor.NonPersistableFileEditorInput;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.util.NameValuePair;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

public class ProjectExplorerDoubleClickListener implements IDoubleClickListener{

	@Override
	public void doubleClick(DoubleClickEvent event) {
		IWorkbenchWindow dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
		IWorkbenchPage page = dwindow.getActivePage();
		
		Object element = ((TreeSelection) event.getSelection()).getFirstElement();
		if (element instanceof NodeDefinitionDTO) {
			NodeDefinitionDTO nodeDefinitionDTO = (NodeDefinitionDTO) element;
			
			if(nodeDefinitionDTO.getType() == NodeDefinitionType.SuperState){
			
				IFile gpdFile = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(nodeDefinitionDTO.getPath()));
				try {
					// Opening the editor
					NonPersistableFileEditorInput fileInput = new NonPersistableFileEditorInput(gpdFile, nodeDefinitionDTO);
					IDE.openEditor(page, fileInput, Utility.NODEDEF_EDITOR_ID, true);
				} catch (PartInitException e) {
					throw new UIException(
							"Error opening Editor.", e);
				}
			}
		}
		
		if( element instanceof ResourceType ){
			ResourceType resourceType = (ResourceType)element;
			IFile pluginFile = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(resourceType.getPath()));
			try {
				// Opening the editor
				FileEditorInput fileInput = new FileEditorInput(pluginFile);
				IDE.openEditor(page, fileInput, Utility.RESOURCE_TYPE_EDITOR_ID, true);
			} catch (PartInitException e) {
				throw new UIException(
						"Error opening Editor.", e);
			}
		}
		
		if( element instanceof WPVariable ){
			WPVariable variable = (WPVariable) element;
			ModifyParameterAction modifyParameterAction = new ModifyParameterAction();
			modifyParameterAction.setActivePart(null, page.getActivePart());
			TreePath path = ((TreeSelection) event.getSelection()).getPaths()[0];
			/* Tree is:
			 * - Project -> ResourceType -> NodeDefinition -> WPVariable
			 */
			NodeDefinitionDTO nodeDefinition = (NodeDefinitionDTO) path.getSegment(path.getSegmentCount() - 2);
			if (NodeDefinitionType.MessageNode.equals(nodeDefinition.getType())) {
				modifyParameterAction.run(variable, nodeDefinition);
			}
		}
		
		if( element instanceof NameValuePair ){
			NameValuePair variable = (NameValuePair) element;
			ModifyParameterAction modifyParameterAction = new ModifyParameterAction();
			modifyParameterAction.setActivePart(null, page.getActivePart());
			TreePath path = ((TreeSelection) event.getSelection()).getPaths()[0];
			/* Tree is:
			 * - Project -> ResourceType -> NodeDefinition -> WPVariable
			 */
			NodeDefinitionDTO nodeDefinition = (NodeDefinitionDTO) path.getSegment(path.getSegmentCount() - 2);
			if (NodeDefinitionType.MessageNode.equals(nodeDefinition.getType())) {
				modifyParameterAction.run(variable, nodeDefinition);
			}
		}
	}
}
