package com.tandbergtv.watchpoint.studio.ui.wizard;
/**
 * Class containing constants used by the mapping tool.
 * @author Patrik Araujo
 */
public class RTPConstants {
	
	/* Watch point studio project preferences node name */
	public static final String STUDIO_PREFERENCES_NODE = "com.tandbergtv.watchpoint.studio";
	
	/* Constant used to define the schema file name defined to a project */
	public static final String SCHEMA_FILE_NAME = "schemaFileName";
	
	/* Resource type project adaptor folder path */
	public static final String ADAPTOR_FOLDER_PATH = "resources/adaptor/";
	
	/* WPCL message template file name */
	public static final String WPCL_MESSAGE_TEMPLATE_FILE_NAME = "incoming.xml";
	
	/* Outgoing mapping file name */
	public static final String OUTGOING_MAPPING_FILE_NAME = "outgoing.xml";
	
	/* Incoming mapping file name */
	public static final String INCOMING_MAPPING_FILE_NAME = "incoming.xml";
	
	/* Adaptor file name */
	public static final String ADAPTOR_FILE_NAME = "adaptor.xml";
	
	/* Regex expressions for timeout field validation */
	public static final String REGEX_SHORT_DURATION = "[0-23][0-23]:\\d\\d:\\d\\d";
	public static final String REGEX_LONG_DURATION = "\\d\\dT[0-23][0-23]:\\d\\d:\\d\\d";
	
	/* Timeout wrong format error message */
	public static final String TIMEOUT_WRONG_FORMAT_MESSAGE = "Timeout field wrong format. (e.g. 01T00:10:20, 00:10:20)";
	
}
