/*******************************************************************************
 *  Copyright (c) 2000, 2010 IBM Corporation and others.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 *  Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.tandbergtv.watchpoint.studio.ui.wizard.export;

import static com.tandbergtv.watchpoint.studio.ui.wizard.export.ResourceTypeExportConstants.BUILD_PROPERTIES_FILE;

import java.util.ArrayList;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.ui.statushandlers.StatusManager;

import com.tandbergtv.watchpoint.studio.builder.WatchpointResourceTypeNature;

@SuppressWarnings("restriction")
public class ResourceTypeExportWizardPage extends BaseExportWizardPage {

	public ResourceTypeExportWizardPage(IStructuredSelection selection) {
		super(selection, "pluginExport", //$NON-NLS-1$
				"Available Resource Type Projects");
		setTitle("Resource Type Export");
	}

	protected Object getInput() {
		return PDECore.getDefault().getModelManager();
	}

	public Object[] getListElements() {
		IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
		ArrayList<IProject> result = new ArrayList<IProject>();
		for (int i = 0; i < projects.length; i++) {
			if ( hasBuildProperties(projects[i]) && isResourceTypeProject(projects[i])) {
				result.add(projects[i]);
			}
		}
		return result.toArray();
	}
	
	private boolean isResourceTypeProject(IProject project) {
		boolean isResourceTypeProject = false;
		try {
			isResourceTypeProject = project.hasNature(WatchpointResourceTypeNature.NATURE_ID);
		} catch (CoreException e) {
			String errorMessage = "Error verifying the project " + project.getName() + " nature.";
			Status status = new Status(IStatus.ERROR, "WatchPoint Studio",IStatus.ERROR, errorMessage, e);
			StatusManager.getManager().handle(status, StatusManager.SHOW);
		}
		return isResourceTypeProject;
	}

	private boolean hasBuildProperties(IProject project) {
		IFile file = project.getFile(BUILD_PROPERTIES_FILE);
		return file.exists();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizardPage#isValidModel(org.eclipse.pde.core.IModel)
	 */
	protected boolean isValidModel(IModel model) {
		return model != null && model instanceof IPluginModelBase;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizardPage#findModelFor(org.eclipse.core.runtime.IAdaptable)
	 */
	protected IModel findModelFor(IAdaptable object) {
		if (object instanceof IJavaProject)
			object = ((IJavaProject) object).getProject();

		return null;
	}
	
	public void updateErrorMessage(String errorMessage) {
		setErrorMessage(errorMessage);
		getContainer().updateButtons();
	}
}
