/**
 * Importer.java
 * Created Feb 17, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.wizard.imports;

import java.util.Collection;

import org.eclipse.core.runtime.IProgressMonitor;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.ui.sync.IDiffModel;

/**
 * Interface for importing artifacts into the local repository
 * 
 * @author Sahil Verma
 */
public interface Importer {
	
	/**
	 * Returns the diff model for the given items
	 * 
	 * @return the diff model
	 */
	IDiffModel getDiffModel(Collection<? extends IWatchPointDTO> items, IProgressMonitor monitor);
	
	/**
	 * Imports the specified items
	 * 
	 * @param items
	 * @param monitor
	 */
	void importItems(IDiffModel diffModel, IProgressMonitor monitor);
}
