package com.tandbergtv.watchpoint.studio.ui.wizard.resourcegroup;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.jbpm.gd.jpdl.wizard.NewResourceGroupWizardPageCustom;

import com.tandbergtv.watchpoint.studio.builder.WatchpointResourceTypeNature;
import com.tandbergtv.watchpoint.studio.builder.WatchpointTemplateNature;
import com.tandbergtv.watchpoint.studio.service.IResourceGroupService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;

/**
 * 		Wizard for new ResourceGroups
 * 
 * @author <a href="francisco.neto@venturus.org.br">vntfrne Francisco Bento da Silva Neto</a>
 *
 */
public class NewResourceGroupWizardPage extends NewResourceGroupWizardPageCustom {
	

	public NewResourceGroupWizardPage(String suggestedFolder) {
		super(suggestedFolder);
	}

	@Override
	public ViewerFilter createViewerFilter() {
		ViewerFilter filter= new ViewerFilter() {
			public boolean select(Viewer viewer, Object parent, Object element) {
				boolean filter = false;
				
				IProject project = null;
				if (IFolder.class.isInstance(element)) {
					IFolder folder = (IFolder) element;
					project = folder.getProject();
				} else if (IProject.class.isInstance(element)){
					project = (IProject) element;
				}
				if (project != null) {
					try {
						// Will only show projects that have the Watchpoint template nature or RType nature.
						filter = project.hasNature(WatchpointTemplateNature.NATURE_ID)
						      || project.hasNature(WatchpointResourceTypeNature.NATURE_ID);
					} catch (CoreException e) {}
				}
				return filter;
			}
		};
		return filter;
	}
	
	@Override	
	public boolean processExists() {
		IResourceGroupService service = ServiceFactory.createFactory().createResourceGroupService();
		return service.isNameExists(super.getProcessName());
	}
	
}
