/*
 * Created on Jul 31, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.util;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.watchpoint.studio.application.StudioRuntimeException;

/**
 * Utility class that provides helper reflection methods.
 * 
 * @author Vijay Silva
 */
public final class ClassLoaderUtil
{
	// Constructor, cannot instantiate
	private ClassLoaderUtil()
	{
	}

	/**
	 * Instantiate an instance of a Factory Class given the class name and the abstract factory
	 * class type.
	 * 
	 * @param <T>
	 *            The type of the abstract factory for which an instance is being created
	 * @param factoryClassName
	 *            The Class Name of the instance being created.
	 * @param factoryType
	 *            The Class of the abstract factory
	 * 
	 * @return An instance of the specified factory class name.
	 */
	@SuppressWarnings("unchecked")
	public static <T> T createFactoryInstance(String factoryClassName, Class<T> factoryType, Object... args)
	{
		try
		{
			/* Create the factory */
			Class<?> clazz = Class.forName(factoryClassName);
			Object factoryInstance = null;
			if (args == null) {
	            factoryInstance = clazz.newInstance();
			} else {
			    List<Class<? extends Object>> types = new ArrayList<Class<? extends Object>>();
			    for (Object o : args) {
			        types.add(o.getClass());
			    }
			    Constructor constructor = clazz.getConstructor(types.toArray(new Class[0]));
			    factoryInstance = constructor.newInstance(args);
			}
			return (T) factoryInstance;
		}
		catch (Exception ex)
		{
			String factoryName = factoryType.getClass().getSimpleName();
			String msg = "Failed to instantiate the " + factoryName + " implementation: "
					+ factoryClassName;
			throw new StudioRuntimeException(msg, ex);
		}
	}
}
