/**
 * 
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement;

import static com.tandbergtv.watchpoint.studio.validation.ValidationMessageType.Error;

import java.util.ArrayList;
import java.util.List;

import org.jbpm.gd.jpdl.model.Action;

import com.tandbergtv.watchpoint.studio.ui.model.AbstractTaskNode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationRule;
import com.tandbergtv.watchpoint.studio.validation.impl.ValidationMessageAdder;

/**
 * Validation rule that verifies that a Action class has been defined for the Abstract Task Node.
 * 
 * @author Devender Reddy
 * @author Vijay Silva
 */
public class TaskNodeActionRequiredRule extends ValidationRule<AbstractTaskNode> {

	/**
	 * Check that class name is defined for an action.
	 * 
	 * @param target
	 *            The AbstractTaskNode to validate
	 * 
	 * @return The List of validation messages
	 * 
	 * @see com.tandbergtv.watchpoint.studio.validation.IValidationRule#validateRule(java.lang.Object)
	 */
	public List<ValidationMessage> validateRule(AbstractTaskNode target) {
		List<ValidationMessage> messages = new ArrayList<ValidationMessage>();

		Action action = target.getAction();
		String actionClassName = (action != null) ? action.getClassName() : null;
		if (actionClassName == null || actionClassName.trim().length() == 0) {
			ValidationMessageCode code = ValidationMessageCode.NODE_ACTION_CLASS_BLANK;
			ValidationMessageAdder.getInstance().addValidationMessage(messages, target, code);
		}

		return messages;
	}
}
