package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.assignnode;

import java.util.ArrayList;
import java.util.List;

import org.jbpm.gd.jpdl.model.Variable;

import com.tandbergtv.watchpoint.studio.ui.model.AssignNode;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationRule;
import com.tandbergtv.watchpoint.studio.validation.impl.ValidationMessageAdder;

public class AssignNodeNameValidRule extends ValidationRule<AssignNode> {

    @Override
    public List<ValidationMessage> validateRule(AssignNode target) {
        List<ValidationMessage> messages = new ArrayList<ValidationMessage>();

        if (target.getTasks() == null || target.getTasks().length == 0 || target.getTasks()[0] == null
                || target.getTasks()[0].getController() == null) {
            return messages;
        }

        WorkflowTemplate template = Utility.getTemplate(target);

        for (Variable variable : target.getTasks()[0].getController().getVariables()) {
            if (!template.hasVariable(variable.getName())) {
                List<String> parameters = new ArrayList<String>();
                parameters.add(variable.getName());
                ValidationMessageAdder.getInstance().addValidationMessage(messages, target,
                        ValidationMessageCode.NODE_VARIABLE_MAPPING_INVALID_IN_ASSIGN_NODE, parameters);
            }
        }

        return messages;
    }
}
