/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.model;

import com.tandbergtv.watchpoint.studio.debugger.model.SimulationData;
import java.util.HashMap;
import java.util.Map;

public class ParameterizableSimulationData
extends SimulationData {
    public ParameterizableSimulationData(Map simulationAttributes) {
        super(simulationAttributes);
    }

    public ParameterizableSimulationData() {
    }

    public ParameterizableSimulationData(SimulationData simulationData) {
        this(simulationData.simulationAttributes);
    }

    public Object getVariable(String variableName) {
        String key = "variables." + variableName;
        return this.simulationAttributes.get(key);
    }

    public Map<String, Object> getVariables() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Object obj : this.simulationAttributes.keySet()) {
            String key = obj.toString().replaceFirst("variables.", "");
            map.put(key, this.simulationAttributes.get(obj.toString()));
        }
        return map;
    }

    public boolean hasVariable(String variableName) {
        String key = "variables." + variableName;
        return this.simulationAttributes.containsKey(key);
    }

    public Object setVariable(String variableName, Object value) {
        String key = "variables." + variableName;
        return this.simulationAttributes.put(key, value);
    }

    public Object setFail(boolean fail) {
        String key = "fail";
        return this.simulationAttributes.put(key, fail);
    }

    public boolean isFail() {
        String key = "fail";
        String failStr = (String)this.simulationAttributes.get(key);
        boolean isFail = false;
        if (failStr != null && !failStr.trim().isEmpty()) {
            isFail = Boolean.valueOf(failStr);
        }
        return isFail;
    }
}

