/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.ui;

import com.tandbergtv.watchpoint.studio.debugger.model.NodeSimulationConfig;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.LoopNode;
import com.tandbergtv.watchpoint.studio.ui.model.MailNode;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.NodeGroup;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.jbpm.gd.common.model.GenericElement;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.ProcessState;

public class NodeSimulationTableLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public static final String CHECKED_IMAGE = "checked.gif";
    public static final String UNCHECKED_IMAGE = "unchecked.gif";
    private static ImageRegistry imageRegistry = new ImageRegistry();

    static {
        imageRegistry.put(CHECKED_IMAGE, Utility.getImageDescriptor((String)CHECKED_IMAGE));
        imageRegistry.put(UNCHECKED_IMAGE, Utility.getImageDescriptor((String)UNCHECKED_IMAGE));
    }

    public String getColumnText(Object element, int columnIndex) {
        String result = null;
        NodeSimulationConfig nodeSimulation = (NodeSimulationConfig)element;
        switch (columnIndex) {
            case 0: {
                NodeDefinition nodeDefinition;
                result = nodeSimulation.getNodeElement().getLabel();
                if (!(nodeSimulation.getNodeElement() instanceof NodeDefinition) || !((nodeDefinition = (NodeDefinition)nodeSimulation.getNodeElement()).getNode() instanceof NodeGroup)) break;
                result = nodeDefinition.getNode().getLabel();
                break;
            }
            case 1: {
                result = nodeSimulation.getNodeElement().getName();
                break;
            }
            case 2: {
                result = this.getNodeSpecificData(nodeSimulation.getNodeElement());
                break;
            }
            case 3: {
                if (nodeSimulation.getSimulationType() != null) {
                    result = nodeSimulation.getSimulationType().getLabel();
                    break;
                }
                result = "";
                break;
            }
            case 4: {
                result = "";
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    protected String getNodeSpecificData(NodeElement nodeElement) {
        String result = "";
        if (nodeElement instanceof NodeDefinition) {
            result = this.getNodeSpecificData((NodeDefinition)nodeElement);
        } else if (nodeElement instanceof AutomaticTaskNode) {
            result = this.getNodeSpecificData((AutomaticTaskNode)nodeElement);
        } else if (nodeElement instanceof Decision) {
            result = this.getNodeSpecificData((Decision)nodeElement);
        } else if (nodeElement instanceof ProcessState) {
            result = this.getNodeSpecificData((ProcessState)nodeElement);
        } else if (nodeElement instanceof LoopNode) {
            result = this.getNodeSpecificData((LoopNode)nodeElement);
        } else if (nodeElement instanceof MailNode) {
            result = this.getNodeSpecificData((MailNode)nodeElement);
        }
        return result;
    }

    protected String getNodeSpecificData(NodeDefinition nodeDefinition) {
        String result = nodeDefinition.getDefinitionName();
        if (nodeDefinition.getNode() instanceof AutomaticTaskNode) {
            AutomaticTaskNode automaticNode = (AutomaticTaskNode)nodeDefinition.getNode();
            Action actionNode = automaticNode.getAction();
            GenericElement ge = actionNode.getGenericElements()[0];
            String messageUID = ge.getValue();
            IResourceTypeService service = ServiceFactory.createFactory().createResourceTypeService();
            Message message = service.findMessageByUID(messageUID);
            if (message != null) {
                result = String.valueOf(message.getResourceType().getName()) + "." + message.getName();
            }
        } else if (nodeDefinition.getNode() != null) {
            NodeGroup group = (NodeGroup)nodeDefinition.getNode();
            NodeElement[] nodeElementArray = group.getNodeElements();
            int n = nodeElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                NodeElement ssElement = nodeElementArray[n2];
                if (ssElement instanceof NodeDefinition) {
                    NodeDefinition nd = (NodeDefinition)ssElement;
                    IResourceTypeService service = ServiceFactory.createFactory().createResourceTypeService();
                    Message message = service.findMessageByUID(nd.getUid());
                    if (message == null) break;
                    result = String.valueOf(message.getResourceType().getName()) + "." + result;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    protected String getNodeSpecificData(Decision decision) {
        String result = decision.getExpression();
        return result;
    }

    protected String getNodeSpecificData(LoopNode loop) {
        String result = loop.getExpression();
        return result;
    }

    protected String getNodeSpecificData(ProcessState process) {
        String result = process.getSubProcess().getName();
        return result;
    }

    protected String getNodeSpecificData(MailNode mail) {
        String subject = "";
        if (mail.getSubject() != null && (subject = mail.getSubject().getSubject()) == null) {
            subject = "";
        }
        String result = "To: " + mail.getTo() + " Subject: " + subject;
        return result;
    }

    protected String getNodeSpecificData(AutomaticTaskNode automaticNode) {
        Action actionNode = automaticNode.getAction();
        return actionNode.getClassName();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = null;
        return image;
    }
}

