/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.ui;

import com.tandbergtv.watchpoint.studio.debugger.ui.SimulationModifyListener;
import com.tandbergtv.watchpoint.studio.debugger.ui.VariableValuesTableCellModifier;
import com.tandbergtv.watchpoint.studio.debugger.ui.VariableValuesTableComparator;
import com.tandbergtv.watchpoint.studio.debugger.ui.VariableValuesTableLabelProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.jbpm.gd.jpdl.model.Variable;

public class VariableValuesTable {
    protected Table table;
    protected TableViewer tableViewer;
    private List<SimulationModifyListener> simulationModifyListeners = new ArrayList<SimulationModifyListener>();
    protected static final int VALUE_COLUMN_INDEX = 2;
    protected String lastSortedColumn;
    protected boolean sortDesc;
    public static final String VARIABLE_COLUMN = "variable";
    public static final String TYPE_COLUMN = "type";
    public static final String VALUE_COLUMN = "value";
    public static final String[] COLUMN_NAMES = new String[]{"variable", "type", "value"};

    public VariableValuesTable(Composite parent) {
        this.createControls(parent);
    }

    private void createControls(Composite composite) {
        this.createTable(composite);
        this.createTableViewer();
    }

    public void setVariablesData(Collection<Variable> variables) {
        this.tableViewer.setInput(variables);
    }

    public Collection<Variable> getVariablesData() {
        return (Collection)this.tableViewer.getInput();
    }

    private void createTable(Composite parent) {
        int style = 101124;
        this.table = new Table(parent, style);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.table, 16384, 0);
        column.setText("Variable");
        column.setWidth(150);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VariableValuesTable.this.sortTable(VariableValuesTable.VARIABLE_COLUMN);
            }
        });
        column = new TableColumn(this.table, 16384, 1);
        column.setText("Type");
        column.setWidth(150);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VariableValuesTable.this.sortTable(VariableValuesTable.TYPE_COLUMN);
            }
        });
        column = new TableColumn(this.table, 16384, 2);
        column.setText("Value");
        column.setWidth(300);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VariableValuesTable.this.sortTable(VariableValuesTable.VALUE_COLUMN);
            }
        });
    }

    protected void sortTable(String column) {
        this.sortDesc = column.equals(this.lastSortedColumn) ? !this.sortDesc : false;
        VariableValuesTableComparator comparator = new VariableValuesTableComparator(column, this.sortDesc, (ITableLabelProvider)this.tableViewer.getLabelProvider());
        this.tableViewer.setComparator((ViewerComparator)comparator);
        this.lastSortedColumn = column;
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(COLUMN_NAMES);
        CellEditor[] editors = new CellEditor[COLUMN_NAMES.length];
        editors[2] = new TextCellEditor((Composite)this.table);
        this.tableViewer.setCellEditors(editors);
        this.tableViewer.setCellModifier((ICellModifier)new VariableValuesTableCellModifier(this));
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new VariableValuesTableLabelProvider());
    }

    public void close() {
        Shell shell = this.table.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.dispose();
        }
    }

    public List<String> getColumnNames() {
        return Arrays.asList(COLUMN_NAMES);
    }

    public ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    public Control getControl() {
        return this.table.getParent();
    }

    public void updateNode(Variable var) {
        this.tableViewer.update((Object)var, null);
        for (SimulationModifyListener varModifyListener : this.simulationModifyListeners) {
            varModifyListener.modifySimulation(var);
        }
    }

    public void refresh() {
        this.tableViewer.refresh();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.table.addSelectionListener(listener);
    }

    public void addSimulationModifyListener(SimulationModifyListener listener) {
        this.simulationModifyListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.table.removeSelectionListener(listener);
    }

    public void setVisible(boolean visible) {
        this.table.setVisible(visible);
    }

    public void setEnabled(boolean enabled) {
        this.table.setEnabled(enabled);
    }

    public void dispose() {
        this.tableViewer.getLabelProvider().dispose();
    }

    public void setLabelProvider(ITableLabelProvider labelProvider) {
        this.tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }
}

