/*
 * Created on Jun 22, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.dataaccess;

import com.tandbergtv.watchpoint.studio.util.ClassLoaderUtil;

/**
 * Factory that creates and initializes a Persistence Context that can be used by the application.
 * The Factory also provides implementation to close the context.
 * 
 * @author Vijay Silva
 */
public abstract class PersistenceContextFactory
{
	private static final String DEFAULT_FACTORY = "com.tandbergtv.watchpoint.studio.dataaccess.jpa.JPAPersistenceContextFactory";

	/**
	 * Default Constructor
	 */
	protected PersistenceContextFactory()
	{
		super();
	}

	/**
	 * Return the configured Persistence Context Factory to use for creating a Persistence Context.
	 * 
	 * @return The PersistenceContextFactory
	 */
	public static PersistenceContextFactory createFactory()
	{
		return ClassLoaderUtil.createFactoryInstance(DEFAULT_FACTORY, PersistenceContextFactory.class);
	}

	/**
	 * Create a new Persistence Context
	 * 
	 * @return The newly created Persistence Context
	 */
	public abstract IPersistenceContext createPersistenceContext();
}
