/*
 * Created on Mar 20, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.external.jpf.model;

import java.util.Hashtable;
import java.util.Map;

/**
 * Entity that contains information about the Adaptor used for a Resource Type.
 * 
 * @author Vijay Silva
 */
public class AdaptorDescriptor implements WatchPointDescriptor
{
	private static final long serialVersionUID = -3068829051897530429L;

	/* The Message Identifier Class to use when using the Default Adaptor */
	private String messageIdentifierClass;

	/* The Adaptor class to use, null indicates that the default adaptor should be used */
	private String adaptorClass;

	/* The scope of the Adaptor */
	private ScopeDescriptor scope;

	/* The Properties used to initialize the Adaptor Instance (not used for default adaptor) */
	private Map<String, String> properties;

	/**
	 * @return the adaptorClass
	 */
	public String getAdaptorClass()
	{
		return this.adaptorClass;
	}

	/**
	 * @param adaptorClass
	 *            the adaptorClass to set
	 */
	public void setAdaptorClass(String adaptorClass)
	{
		this.adaptorClass = adaptorClass;
	}

	/**
	 * @return the messageIdentifierClass
	 */
	public String getMessageIdentifierClass()
	{
		return this.messageIdentifierClass;
	}

	/**
	 * @param messageIdentifierClass
	 *            the messageIdentifierClass to set
	 */
	public void setMessageIdentifierClass(String messageIdentifierClass)
	{
		this.messageIdentifierClass = messageIdentifierClass;
	}

	/**
	 * @return the properties
	 */
	public Map<String, String> getProperties()
	{
		return this.properties;
	}

	/**
	 * @param properties
	 *            the properties to set
	 */
	public void setProperties(Map<String, String> properties)
	{
		this.properties = properties;
	}

	/**
	 * @return the scope
	 */
	public ScopeDescriptor getScope()
	{
		return this.scope;
	}

	/**
	 * @param scope
	 *            the scope to set
	 */
	public void setScope(ScopeDescriptor scope)
	{
		this.scope = scope;
	}

	/**
	 * Method to check if the default adaptor is used.
	 * 
	 * @return true if default adaptor, false otherwise.
	 */
	public boolean isDefault()
	{
		return (this.adaptorClass == null);
	}

	/**
	 * @see java.lang.Object#clone()
	 */
	@Override
	public Object clone()
	{
		AdaptorDescriptor clone = null;

		try
		{
			clone = (AdaptorDescriptor) super.clone();

			if (this.properties != null)
				clone.properties = new Hashtable<String, String>(this.properties);
		}
		catch (CloneNotSupportedException ex)
		{ // Should never happen
		}

		return clone;
	}
}
