/*
 * Created on Mar 20, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.external.jpf.model;

import java.util.Date;
import java.util.Hashtable;
import java.util.Map;

/**
 * Entity that contains all the information collected from the Resource Type Plugin Extension.
 * 
 * @author Vijay Silva
 */
public class ResourceTypeDescriptor implements WatchPointDescriptor,
		Comparable<ResourceTypeDescriptor> {
	private static final long serialVersionUID = 3165041717297643121L;

	/* The System Id for the Resource Type */
	private String systemId;

	/* The name for the Resource Type */
	private String name;

	/* The create date for the Resource Type */
	private Date createDate;

	/* The summary message for the Resource Type - used to store the reason for non-licensed resource types*/
	private String summaryMessage;

	/* The description of the Resource Type */
	private String description;

	/* The default protocol used for communication */
	private String defaultProtocol;

	/* The list of Messages supported by the Resource Type */
	private Map<String, MessageDescriptor> messages = new Hashtable<String, MessageDescriptor>();

	/* The Management properties for the Resource Type */
	private ManagementDescriptor management;

	/* The Adaptor related properties for the Resource Type */
	private AdaptorDescriptor adaptor;

	/* The Classloader that must be used for loading classes / resources for this descriptor */
	private ClassLoader classLoader;

	/* The parent plugin Id */
	private String pluginId;

	/* The parent extension Id */
	private String extensionId;
	
	private int version;

	private String location;

	/**
	 * @return the adaptor
	 */
	public AdaptorDescriptor getAdaptor() {
		return this.adaptor;
	}

	/**
	 * @param adaptor
	 *            the adaptor to set
	 */
	public void setAdaptor(AdaptorDescriptor adaptor) {
		this.adaptor = adaptor;
	}

	/**
	 * @return the classloader
	 */
	public ClassLoader getClassLoader() {
		return this.classLoader;
	}

	/**
	 * @param classLoader
	 *            the classloader to set
	 */
	public void setClassLoader(ClassLoader classLoader) {
		this.classLoader = classLoader;
	}

	/**
	 * @return the defaultProtocol
	 */
	public String getDefaultProtocol() {
		return this.defaultProtocol;
	}

	/**
	 * @param defaultProtocol
	 *            the defaultProtocol to set
	 */
	public void setDefaultProtocol(String defaultProtocol) {
		this.defaultProtocol = defaultProtocol;
	}

	/**
	 * @return the description
	 */
	public String getDescription() {
		return this.description;
	}

	/**
	 * @param description
	 *            the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * @return the management
	 */
	public ManagementDescriptor getManagement() {
		return this.management;
	}

	/**
	 * @param management
	 *            the management to set
	 */
	public void setManagement(ManagementDescriptor management) {
		this.management = management;
	}

	/**
	 * @return the messages
	 */
	public Map<String, MessageDescriptor> getMessages() {
		return this.messages;
	}

	/**
	 * @param messages
	 *            the messages to set
	 */
	public void setMessages(Map<String, MessageDescriptor> messages) {
		this.messages = messages;
	}

	/**
	 * @return the createDate.
	 */
	public Date getCreateDate() {
		return createDate;
	}

	/**
	 * @param createDate 
	 * 				The createDate to set.
	 */
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return this.name;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the systemId
	 */
	public String getSystemId() {
		return this.systemId;
	}

	/**
	 * @param systemId
	 *            the systemId to set
	 */
	public void setSystemId(String systemId) {
		this.systemId = systemId;
	}

	/**
	 * @return the extensionId
	 */
	public String getExtensionId() {
		return this.extensionId;
	}

	/**
	 * @param extensionId
	 *            the extensionId to set
	 */
	public void setExtensionId(String extensionId) {
		this.extensionId = extensionId;
	}

	/**
	 * @return the pluginId
	 */
	public String getPluginId() {
		return this.pluginId;
	}

	/**
	 * @param pluginId
	 *            the pluginId to set
	 */
	public void setPluginId(String pluginId) {
		this.pluginId = pluginId;
	}

	/**
	 * 
	 * @param msg
	 */
	public void setSummaryMessage(String msg) {
		this.summaryMessage = msg;
	}

	public String getSummaryMessage() {
		return this.summaryMessage;
	}

	/**
	 * @return the location
	 */
	public String getLocation() {
		return location;
	}

	/**
	 * @param location the location to set
	 */
	public void setLocation(String location) {
		this.location = location;
	}

	/**
	 * @return the version
	 */
	public int getVersion() {
		return version;
	}

	/**
	 * @param version the version to set
	 */
	public void setVersion(int version) {
		this.version = version;
	}

	/**
	 * @see java.lang.Object#clone()
	 */
	@Override
	public Object clone() {
		ResourceTypeDescriptor clone = null;

		try {
			clone = (ResourceTypeDescriptor) super.clone();

			if (this.messages != null) {
				clone.messages = new Hashtable<String, MessageDescriptor>();
				for (String uid : this.messages.keySet()) {
					MessageDescriptor desc = (MessageDescriptor) this.messages.get(uid).clone();
					clone.messages.put(uid, desc);
				}
			}

			if (this.management != null)
				clone.management = (ManagementDescriptor) this.management.clone();

			if (this.adaptor != null)
				clone.adaptor = (AdaptorDescriptor) this.adaptor.clone();

			if (this.createDate != null)
				clone.createDate = (Date) this.createDate.clone();
		} catch (CloneNotSupportedException ex) { // Should never happen
		}

		return clone;
	}

	public int compareTo(ResourceTypeDescriptor obj) {
		if (this.createDate.after(obj.getCreateDate()))
			return 1;
		else
			return -1;
	}
}
