package com.tandbergtv.watchpoint.studio.ui.editor;

import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public class TemplateEditorCopyAction extends TemplateEditorCopyCommandHandler implements IEditorActionDelegate {
	List<Object> copiableObjects; 
	
	@Override
	public void run(IAction action) {
		if( !copiableObjects.isEmpty() ){
			TemplateEditorCopyCommand command = new TemplateEditorCopyCommand( copiableObjects );
			command.execute();
		}
	}

	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		if(selection instanceof StructuredSelection){
			IStructuredSelection editorSelection = (StructuredSelection) selection;
			copiableObjects = getElementsList(editorSelection);
		}
	}
	
	@Override
	public void setActiveEditor(IAction action, IEditorPart targetEditor) {
	}

}
