package com.tandbergtv.watchpoint.studio.ui.editor;

import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.jpdl.command.EdgeMoveCommand;
import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.Fork;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Transition;
import org.jbpm.gd.jpdl.notation.JpdlNodeContainer;

/**
 * @author rprakash
 *
 * Custom Edge Move Command that gets executed when a new Transition's
 * source or target is changed in the UI.
 */
public class WPEdgeMoveCommand extends EdgeMoveCommand {
	
	private Node target;
	private Node source;

	/**
	 * @see org.jbpm.gd.jpdl.command.EdgeMoveCommand#doMoveSource(org.jbpm.gd.common.notation.Node, org.jbpm.gd.common.notation.Node)
	 */
	@Override
	protected void doMoveSource(Node oldSource, Node newSource) {
		super.doMoveSource(oldSource, newSource);
		setTransitionAttributes();
	}

	/**
	 * @see org.jbpm.gd.jpdl.command.EdgeMoveCommand#doMoveTarget(org.jbpm.gd.common.notation.Node)
	 */
	@Override
	protected void doMoveTarget(Node target) {
		super.doMoveTarget(target);
		setTransitionAttributes();
	}
	
	@Override
	public boolean canExecute() {
		boolean canExecute = true;
		canExecute = super.canExecute();
		Node edgeSource = getEdge().getSource();
		Node edgeTarget = getEdge().getTarget();
		
		if(target != null && edgeSource != null){
			/* Unable the command if the source and target are in different sides of a loop node */
			if ( edgeSource.getContainer() instanceof JpdlNodeContainer && !(target.getContainer() instanceof JpdlNodeContainer) ||
				 target.getContainer() instanceof JpdlNodeContainer && !(edgeSource.getContainer() instanceof JpdlNodeContainer) ){
				canExecute = false;
			}
		}
		if(source != null && edgeTarget != null){
			/* Unable the command if the source and target are in different sides of a loop node */
			if ( edgeTarget.getContainer() instanceof JpdlNodeContainer && !(source.getContainer() instanceof JpdlNodeContainer) ||
				 source.getContainer() instanceof JpdlNodeContainer && !(edgeTarget.getContainer() instanceof JpdlNodeContainer) ){
				canExecute = false;
			}
		}
		return canExecute;
	}

	@Override
	public void setTarget(Node newTarget) {
		super.setTarget(newTarget);
		this.target = newTarget;
	}
	
	@Override
	public void setSource(Node newSource) {
		super.setSource(newSource);
		this.source = newSource;
	}

	private void setTransitionAttributes() {
		NodeElement transitionSource = (NodeElement) getEdge().getSource().getSemanticElement();
		Transition transition = (Transition) getEdge().getSemanticElement();
		if (transitionSource instanceof Decision || transitionSource instanceof Fork) {
			if(isNullOrBlank(transition.getName())) {
				transition.setName("to " + transition.getTo());
				getEdge().getLabel().setText(transition.getName());
			}
		}		
	}
	
	private boolean isNullOrBlank(String str) {
		return (str == null || str.trim().length() == 0);
	}
}
