/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.model;

import java.util.ArrayList;
import java.util.List;

import org.jbpm.gd.common.model.GenericElement;

/**
 * Model element for configInfoElements in WatchPoint Studio.
 * 
 * @author Imran Naqvi
 * 
 */
public class WPConfigInfoElement extends GenericElement {

	private List<WPConfigInfoElement> configInfoElements = new ArrayList<WPConfigInfoElement>();

	public void addConfigInfoElement(GenericElement configInfoElement) {
		configInfoElements.add((WPConfigInfoElement) configInfoElement);
		firePropertyChange("configInfoElementAdd", null, configInfoElement);
	}

	public void removeConfigInfoElement(GenericElement configInfoElement) {
		configInfoElements.remove(configInfoElement);
		firePropertyChange("configInfoElementRemove", configInfoElement, null);
	}
}
