/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.model;

import org.jbpm.gd.jpdl.model.EndState;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.ProcessDefinition;

/**
 * A extension of JBPM's EndState which doesn't allow itself to be added more than once in a NodeDefinition (Super-State).
 * 
 * @author Imran Naqvi
 */
public class WPEndState extends EndState {

	/**
	 * @see org.jbpm.gd.jpdl.model.AbstractNode#isPossibleChildOf(org.jbpm.gd.jpdl.model.NodeElementContainer)
	 */
	@Override
	public boolean isPossibleChildOf(NodeElementContainer nodeElementContainer) {
		if(nodeElementContainer instanceof ProcessDefinition)
			return true;
		
		return  nodeElementContainer instanceof NodeDefinition && !hasEndState(nodeElementContainer);
	}
	
	/*
	 * Checks to see if a NodeElementContainer contains an end node or not.
	 */
	private boolean hasEndState(NodeElementContainer nodeElementContainer){
		for(NodeElement node : nodeElementContainer.getNodeElements()){
			if(node instanceof EndState)
				return true;
		}
		return false;
	}
}
