package com.tandbergtv.watchpoint.studio.ui.preferences;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class SectionStructureReader {
    
    public static Map<KeyAndValue, List<KeyAndValue>> readStructure() {
        ResourceBundle bundle = PropertyResourceBundle.getBundle("com.tandbergtv.watchpoint.studio.ui.preferences.rule-section-pairing");
        // retrieve all key/value pairs into a map
        Map<String, List<String>> itemsBySection = bundleToMap(bundle);

        // translate strings into KeyAndValue
        return translateItemsBySection(itemsBySection);
    }

    private static Map<KeyAndValue, List<KeyAndValue>> translateItemsBySection(Map<String, List<String>> itemsBySection) {
        Map<KeyAndValue, List<KeyAndValue>> result = new HashMap<KeyAndValue, List<KeyAndValue>>();
        String sectionValue = null;
        List<KeyAndValue> rules = null;
        for (String sectionKey : itemsBySection.keySet()) {
            sectionValue = getMessage(sectionKey);
            KeyAndValue section = new KeyAndValue(sectionKey, sectionValue);
            if (result.get(section) == null) {
                rules = new ArrayList<KeyAndValue>();
                result.put(section, rules);
            } else {
                rules = result.get(section);
            }

            KeyAndValue rule = null; 
            String ruleValue = null;
            for (String ruleKey : itemsBySection.get(sectionKey)) {
                ruleValue = getMessage(ruleKey);
                rule = new KeyAndValue(ruleKey, ruleValue);
                rules.add(rule);
            }
        }
        return result;
    }

    private static String getMessage(String sectionKey) {
        try {
            Field field = PreferencesMessages.class.getField(sectionKey);
            return (String) field.get(null);
        } catch (NoSuchFieldException ex) {
            return null;
        } catch (IllegalArgumentException e) {
            return null;
        } catch (IllegalAccessException e) {
            return null;
        }
    }

    private static Map<String, List<String>> bundleToMap(ResourceBundle bundle) {
        Map<String, List<String>> itemsBySection = new HashMap<String, List<String>>();
        List<String> rules = null;
        for (String rule : bundle.keySet()) {
            if (itemsBySection.get(bundle.getString(rule)) == null) {
                rules = new ArrayList<String>();
                itemsBySection.put(bundle.getString(rule), rules);
            } else {
                rules = itemsBySection.get(bundle.getString(rule));
            }
            rules.add(rule);
        }
        return itemsBySection;
    }
}