package com.tandbergtv.watchpoint.studio.ui.properties;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TableColumn;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;

public class MessageNodeVariablesInSuperStateLabelProviderIn extends WPLabelProvider {

    public MessageNodeVariablesInSuperStateLabelProviderIn(TableColumn compositeKeyColumn) {
        this.columns = new TableColumn[] { compositeKeyColumn };
    }

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        WPVariable model = (WPVariable) element;
        if (columnIndex == 2) {
            return getCheckImage(model.isCompositeKey());
        }
        return null;
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
        case 0:
            return ((WPVariable) element).getMappedName();
        case 1:
            return ((WPVariable) element).getName();
        }
        return null;
    }
}
