/**
 * AddMessageCommand.java
 * Created Apr 17, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.sync.resource;

import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.ui.sync.IDiff;
import com.tandbergtv.watchpoint.studio.ui.sync.command.AbstractDiffCommand;
import com.tandbergtv.watchpoint.studio.ui.sync.util.ISynchronizationContext;

/**
 * Adds a new message to a resource type
 * 
 * @author Sahil Verma
 */
public class AddMessageCommand extends AbstractDiffCommand {

	private Message model;
	
	private ISynchronizationContext context;
	
	/**
	 * @param name
	 * @param description
	 * @param enabled
	 * @param diff
	 */
	public AddMessageCommand(String name, IDiff diff, ISynchronizationContext context) {
		super(name, diff, context);
		this.model = (Message) diff.getModel();
		this.context = context;
	}

	/**
	 * {@inheritDoc}
	 */
	public void execute() {
		context.addMessage(model);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return model + " " + diff.getKind();
	}
}
