/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.view;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;

/**
 * Content provider class for the validation errors view.
 * 
 * @author Imran Naqvi
 */
public class ValidationContentProvider implements ITreeContentProvider {

	private List<ValidationMessage> allMessages = null;

	private Map<ValidationMessageType, ValidationMessageGroup> messageGroups;

	/**
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	@SuppressWarnings("unchecked")
	public Object[] getElements(Object inputElement) {
		this.allMessages = (List<ValidationMessage>) inputElement;
		this.messageGroups = new HashMap<ValidationMessageType, ValidationMessageGroup>();

		// Create the sub-objects to display
		ValidationMessageType[] messageTypes = ValidationMessageType.values();
		int typeCount = (messageTypes != null) ? messageTypes.length : 0;
		Object[] elements = new Object[typeCount];

		for (int i = 0; i < typeCount; i++) {
			ValidationMessageGroup group = null;
			int elementIndex = typeCount - (i + 1);
			group = new ValidationMessageGroup(messageTypes[i], this.allMessages);
			elements[elementIndex] = group;
			this.messageGroups.put(messageTypes[i], group);
		}

		return elements;
	}

	/**
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
	 */
	public Object[] getChildren(Object parent) {
		if (parent instanceof ValidationMessageGroup) {
			List<ValidationMessage> messages = ((ValidationMessageGroup) parent).getMessages();
			if (messages != null)
				return messages.toArray();
		}

		return null;
	}

	/**
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
	 */
	public Object getParent(Object element) {
		if (element instanceof ValidationMessage) {
			return this.messageGroups.get(((ValidationMessage) element).getType());
		}

		return null;
	}

	/**
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
	 */
	public boolean hasChildren(Object element) {
		return (element instanceof ValidationMessageGroup);
	}

	/**
	 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
	 */
	public void dispose() {
	}

	/**
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer,
	 *      java.lang.Object, java.lang.Object)
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
	}
}
