/**
 * ImportOperation.java
 * Created Feb 23, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.wizard.imports;

import static com.tandbergtv.watchpoint.studio.ui.util.Utility.ID_RESOURCE_GROUP;
import static com.tandbergtv.watchpoint.studio.ui.util.Utility.ID_RESOURCE_TYPE;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.tandbergtv.watchpoint.studio.ui.sync.IDiffModel;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.view.AbstractTreeViewExplorer;

/**
 * Performs the import operation as a job
 * 
 * @author Sahil Verma
 */
public class ImportOperation extends WorkspaceJob {

	private IDiffModel diffmodel;
	
	private Importer importer;
	
	private static final Logger logger = Logger.getLogger(ImportOperation.class);
	
	/**
	 * @param name
	 * @param importer
	 * @param items
	 */
	public ImportOperation(String name, IDiffModel diffmodel, Importer importer) {
		super(name);
		this.importer = importer;
		this.diffmodel = diffmodel;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
		monitor.beginTask("Importing items", 1);
		
		try {
			importer.importItems(this.diffmodel, new SubProgressMonitor(monitor, 1));
			
			if (monitor.isCanceled())
				return Status.CANCEL_STATUS;
		} catch (Exception e) {
			logger.error("Import failed", e);
			IStatus status = new Status(IStatus.ERROR, Utility.PLUGIN_ID, "Import failed", e);
			throw new CoreException(status);
		} finally {
			monitor.done();
			updateDisplay();
		}
		
		return Status.OK_STATUS;
	}
	
	/**
	 * Refreshes the tree views so that newly imported items appear. Yep, this is worse than
	 * police brutality.
	 */
	protected void updateDisplay() {
		/* We are currently in a non-UI thread (this is a job, after all). There won't be an active
		 * workbench window unless we make the call in a UI thread. */
		Display.getDefault().syncExec(new Runnable() {
			public void run() {
				refreshViews();
			}
		});
	}
	
	protected void refreshViews() {
		IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
		String [] views = { ID_RESOURCE_GROUP, ID_RESOURCE_TYPE };
		
		for (String viewId : views) {
			IViewPart part =  page.findView(viewId);
		
			if (part != null)
				AbstractTreeViewExplorer.class.cast(part).refresh();
		}
	}
}
