package com.tandbergtv.watchpoint.studio.ui.wizard.resource.fields;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.util.UIValidator;

public class ResourceTypeDescriptionField implements IResourceTypeInputField{
	
	private Text descText;
	
	private Composite composite;
	
	public ResourceTypeDescriptionField() {
		super();
	}

	public Composite getComposite(){
		return this.composite;
	}
	
	@Override
	public Composite createControls(Composite parent, FormData formData) {
		Composite systemControls = new Composite(parent, SWT.NONE);
		FormLayout layoutSys = new FormLayout();
		layoutSys.marginWidth = 0;
		layoutSys.marginHeight = 0;
		systemControls.setLayout(layoutSys);
		
		formData.height = 200;
		
		//description label
		Label descLabel = new Label(systemControls, SWT.NONE);
		descLabel.setText("Description : ");
		
		//description text
		descText = new Text(systemControls, SWT.BORDER | SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL);
		descText.setTextLimit(256);
		
		//description label
		FormData descLabelFD = new FormData();
		descLabel.setLayoutData(descLabelFD);

		//description text
		FormData descTextFD = new FormData();
		descTextFD.top = new FormAttachment(0, 2);
		descTextFD.left = new FormAttachment(30, 2);
		descTextFD.right = new FormAttachment(100, -10);
		descTextFD.bottom = new FormAttachment(100, -10);
		descText.setLayoutData(descTextFD);
		
		this.composite = systemControls;
		return systemControls;
	}

	@Override
	public void setObjectValues(ResourceType rt) {
			rt.setDescription(convertEmptyToNull(descText.getText()));
	}

	@Override
	public void clearControls() {
	}

	@Override
	public void initValues() {
	}

	@Override
	public String validate() {
		return UIValidator.validateValue("Description", descText.getText(), UIValidator.Validation.TRIMMED);
	}

	@Override
	public void setValidationListener(ModifyListener validationListener) {
		descText.addModifyListener(validationListener);
	}
	
	private String convertEmptyToNull(String str) {
		return ((str.length() == 0) ? null : str);
	}

}
