package com.tandbergtv.watchpoint.studio.ui.wizard.template;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.jbpm.gd.jpdl.wizard.NewProcessDefinitionWizardPageCustom;

import com.tandbergtv.watchpoint.studio.builder.WatchpointTemplateNature;

public class NewProcessDefinitionWizardPage extends NewProcessDefinitionWizardPageCustom {

	public NewProcessDefinitionWizardPage() {
		super();
	}

	public ViewerFilter createViewerFilter() {
		ViewerFilter filter= new ViewerFilter() {
			public boolean select(Viewer viewer, Object parent, Object element) {
				boolean filter = false;
				
				IProject project = null;
				if (IFolder.class.isInstance(element)) {
					IFolder folder = (IFolder) element;
					project = folder.getProject();
				} else if (IProject.class.isInstance(element)){
					project = (IProject) element;
				}
				if (project != null) {
					try {
						// Will only show projects that have the Watchpoint template nature.
						filter = project.hasNature(WatchpointTemplateNature.NATURE_ID);
					} catch (CoreException e) {}
				}
				return filter;
			}
		};
		return filter;
	}
	
}
