/*
 * Created on Jul 25, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation;

import com.tandbergtv.watchpoint.studio.application.StudioRuntimeException;

/**
 * Exception thrown by the Validation Service when validation unexpectedly fails.
 * 
 * @author Vijay Silva
 */
public class ValidationServiceException extends StudioRuntimeException
{
	private static final long serialVersionUID = -5439229228860277327L;

	/**
	 * Constructor
	 */
	public ValidationServiceException()
	{
	}

	/**
	 * @param message
	 *            The detail message
	 */
	public ValidationServiceException(String message)
	{
		super(message);
	}

	/**
	 * @param cause
	 *            The nested throwable
	 */
	public ValidationServiceException(Throwable cause)
	{
		super(cause);
	}

	/**
	 * @param message
	 *            The detail message
	 * @param cause
	 *            The nested throwable
	 */
	public ValidationServiceException(String message, Throwable cause)
	{
		super(message, cause);
	}

}
