/*
 * Created on Jul 11, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation;

import com.tandbergtv.watchpoint.studio.util.ClassLoaderUtil;

/**
 * Factory that creates IValidationService instances.
 * 
 * @author Vijay Silva
 */
public abstract class ValidationServiceFactory
{
	private static final String DEFAULT_FACTORY = "com.tandbergtv.watchpoint.studio.validation.impl.DefaultValidationServiceFactory";

	/**
	 * Default constructor
	 */
	protected ValidationServiceFactory()
	{
	}

	/**
	 * Return the configured Factory to use for creating Validation Service Objects.
	 * 
	 * @return The ValidationServiceFactory
	 */
	public static ValidationServiceFactory createFactory()
	{
		return ClassLoaderUtil.createFactoryInstance(DEFAULT_FACTORY, ValidationServiceFactory.class);
	}

	/**
	 * Creates an instance of the Validation Service used to validate the different objects.
	 * 
	 * @return The Validation Service implementation.
	 */
	public abstract IValidationService createValidationService();
}
