/**
 * 
 */
package com.tandbergtv.watchpoint.studio.validation.model;

import java.util.List;

import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Transition;

import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;

/**
 * Validation Model Object that represents a Duration Expression.
 * 
 * @author DReddy
 * @author Vijay Silva
 */
public class ConditionExpression extends ContainerValidationContext
{
	protected NodeElement node;

	protected Transition transition;

	/**
	 * Constructor.
	 * 
	 * @param template
	 *            the workflow template that contains the Transition
	 * @param variables
	 *            the list of variables that may be used in the expression
	 * @param node
	 *            the node from which the transition begins
	 * @param transition
	 *            The Transition with the expression
	 */
	public ConditionExpression(WorkflowTemplate template, List<WPVariable> variables,
			NodeElement node, Transition transition)
	{
		super(template, variables);
		this.node = node;
		this.transition = transition;
	}

	/**
	 * Constructor.
	 * 
	 * @param nodeDefinition
	 *            the node definition that contains the Transition
	 * @param variables
	 *            the list of variables that may be used in the expression
	 * @param node
	 *            the node from which the transition begins
	 * @param transition
	 *            The Transition with the expression
	 */
	public ConditionExpression(NodeDefinition nodeDefinition, List<WPVariable> variables,
			NodeElement node, Transition transition)
	{
		super(nodeDefinition, variables);
		this.node = node;
		this.transition = transition;
	}

	/**
	 * Get the Node from which the transition begins.
	 * 
	 * @return The node
	 */
	public NodeElement getNode()
	{
		return this.node;
	}

	/**
	 * Get the Transition with the expression
	 * 
	 * @return the transition
	 */
	public Transition getTransition()
	{
		return transition;
	}
}
