/*
 * Created on Jan 19, 2012
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation.model;

import org.jbpm.gd.jpdl.model.NodeElementContainer;

import com.tandbergtv.watchpoint.studio.ui.model.LoopNode;

/**
 * Class that represents an instance of a Loop Node that could be part of a Workflow Template.
 * 
 * @param <NEC>
 *            The type of the container that contains this loop node instance
 * 
 * @author Patrik Araujo
 */
public class TemplateLoopNodeInstance
{
	protected NodeElementContainer container;

	protected LoopNode nodeInstance;

	/**
	 * Constructor
	 * 
	 * @param nodeInstance
	 *            The Node Instance
	 * @param parent
	 *            The container (either Template or Node Definition) that contain this node
	 *            instance.
	 */
	public TemplateLoopNodeInstance(LoopNode nodeInstance, NodeElementContainer parent)
	{
		this.container = parent;
		this.nodeInstance = nodeInstance;
	}

	/**
	 * Get the Container which this node loop node instance is part of.
	 * 
	 * @return the parent container
	 */
	public NodeElementContainer getContainer()
	{
		return this.container;
	}

	/**
	 * Get the Loop Node node instance.
	 * 
	 * @return The Loop Node node instance.
	 */
	public LoopNode getNodeInstance()
	{
		return this.nodeInstance;
	}
}
