/*
 * Created on Nov 13, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation.rules.nodedefinition;

import java.util.ArrayList;
import java.util.List;

import org.jbpm.gd.jpdl.model.Variable;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.NodeVariablesUniqueRule;

/**
 * Validate that all the Variables in the Super State have a Unique Name.
 * 
 * @author Vijay Silva
 */
public class SuperStateVariablesUniqueRule extends NodeVariablesUniqueRule<NodeDefinition>
{
	/**
	 * @see com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.NodeVariablesUniqueRule#getVariables(org.jbpm.gd.jpdl.model.NodeElement)
	 */
	@Override
	protected List<Variable> getVariables(NodeDefinition node)
	{
		List<Variable> variables = new ArrayList<Variable>();

		if (node.getNodeType() == NodeDefinitionType.SuperState)
		{
			List<WPVariable> nodeVariables = node.getVariables();
			if (nodeVariables != null)
				variables.addAll(nodeVariables);
		}

		return variables;
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.NodeVariablesUniqueRule#isValidatingUniqueName(org.jbpm.gd.jpdl.model.NodeElement)
	 */
	@Override
	protected boolean isValidatingUniqueName(NodeDefinition node)
	{
		return false;
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.NodeVariablesUniqueRule#getDuplicateMappedNameCode(org.jbpm.gd.jpdl.model.NodeElement)
	 */
	@Override
	protected ValidationMessageCode getDuplicateMappedNameCode(NodeDefinition node)
	{
		return ValidationMessageCode.SUPERSTATE_VARIABLES_DUPLICATE_MAPPED_NAMES;
	}
}
