package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.loopnode;

import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.watchpoint.studio.util.DecisionExprValidationUtil;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationRule;
import com.tandbergtv.watchpoint.studio.validation.impl.ValidationMessageAdder;
import com.tandbergtv.watchpoint.studio.validation.model.LoopNodeExpression;

public class LoopNodeExpressionRule extends ValidationRule<LoopNodeExpression>{
	private static final String PREFIX = "(";
	private static final String SUFFIX = ")";

	@Override
	public List<ValidationMessage> validateRule(LoopNodeExpression target) {
		List<ValidationMessage> messages = new ArrayList<ValidationMessage>();
		
		String expression = PREFIX + target.getLoopNode().getExpression() + SUFFIX;
		
        Object[] valMsg = DecisionExprValidationUtil.isExpressionValid(expression, target.getContainerVariables(), target.getLoopNode());
		
		if (valMsg != null) {
            if (valMsg.length <= 2) {
                ValidationMessageAdder.getInstance().addValidationMessage(messages, valMsg[0], (ValidationMessageCode) valMsg[1]);
            } else {
                ValidationMessageAdder.getInstance().addValidationMessage(messages, valMsg[0], (ValidationMessageCode) valMsg[1], (List<String>) valMsg[2]);
            }
		}
		
		return messages;
	}
}
