package com.tandbergtv.watchpoint.studio.debugger.core;

import org.dom4j.Element;
import org.jbpm.graph.def.Node;
import org.jbpm.jpdl.xml.JpdlXmlReader;

public class MailNode2 extends Node {

	private String to;
	private String subject;
	private String text;
	private String attachment;
	
	private static final long serialVersionUID = 1L;

	public String getTo() {
		return to;
	}

	public String getSubject() {
		return subject;
	}

	public String getText() {
		return text;
	}

	public String getAttachment() {
		return attachment;
	}
	
	public void read(Element element, JpdlXmlReader jpdlReader) {
		to = element.attributeValue("to");
		subject = getProperty("subject", element);
		text = getProperty("text", element);
		attachment = element.attributeValue("attachment");
	}

	protected String getProperty(String property, Element element) {
		String value = element.attributeValue(property);
		if (value == null) {
			Element propertyElement = element.element(property);
			if (propertyElement != null) {
				value = propertyElement.getText();
			}
		}
		
		return value;
	}

}
