/**
 * Exec.java
 * Created Sep 29, 2007
 * Copyright (c) Tandberg Television 2007
 */
package com.tandbergtv.watchpoint.studio.debugger.core.graph;

import java.util.HashSet;
import java.util.Set;

import org.dom4j.Element;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.graph.node.ProcessState;
import org.jbpm.jpdl.xml.JpdlXmlReader;

/**
 * Launches a child process of a specified template, optionally using some initial variables, and then
 * waits for the termination of the child in order to proceed.
 * 
 * @author Sahil Verma
 */
public class ProcessState2 extends ProcessState {

	private static final long serialVersionUID = -5608286665493465148L;
	
	/**
	 * Returns the variables
	 * 
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public Set<VariableAccess> getVariableAccesses() {
		return variableAccesses;
	}
	
	/* (non-Javadoc)
	 * @see org.jbpm.graph.node.ProcessState#read(org.dom4j.Element, org.jbpm.jpdl.xml.JpdlXmlReader)
	 */
	@SuppressWarnings("unchecked")
	public void read(Element element, JpdlXmlReader reader) {
		super.read(element, reader);
		this.variableAccesses = new HashSet<VariableAccess>(reader.readVariableAccesses(element));
	}
}
