package com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.jbpm.context.def.VariableAccess;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.node.DecisionCondition;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;

import com.tandbergtv.watchpoint.studio.debugger.core.graph.Decision2;
import com.tandbergtv.watchpoint.studio.debugger.model.DecisionSimulationData;
import com.tandbergtv.watchpoint.studio.debugger.model.SimulationType;

/**
 * 		
 * @author <a href="mailto:francisco.bento.silva.neto@ericsson.com">efrasio - Francisco Bento da Silva Neto</a>
 *
 */
public class DecisionNodeSimulator extends NodeSimulator {

	protected List<Transition> leavingTransitions = null;
	
	@SuppressWarnings("unchecked")
	@Override
	public void simulate() {
		leavingTransitions = node.getLeavingTransitions();

		String transitionName = null;
		if (SimulationType.FIXED_TRANSITION.equals(simulationConfig.getSimulationType())) {
			transitionName = pickFixedTransition();
		} else if (SimulationType.EXECUTE.equals(simulationConfig.getSimulationType())) {
			transitionName = evaluateExpression();
		}
		if (transitionName != null) {
			for (Object current : leavingTransitions) {
				Transition transition = (Transition) current;
				if (transition.getName().equals(transitionName)) {
					leavingTransitions = new ArrayList<Transition>(1);
					leavingTransitions.add(transition);
					break;
				}
			}
		}

	}
	
	/**
	 * 		Returns the fixed transition configured for this node.
	 * @return the transition name
	 */
	protected String pickFixedTransition() {
		return getSimulationData().getFixedTransitionName();
	}
	
	/**
	 * 		Evaluates the node expressions in order to pick up a transition.
	 * 
	 * @return the transition name
	 */
	@SuppressWarnings("rawtypes")
	protected String evaluateExpression() {
		String transitionName = null;
		Decision2 decisionNode = (Decision2) super.node;
		if (decisionNode.getDecisionExpression() != null) {
			Object result = JbpmExpressionEvaluator.evaluate(decisionNode.getDecisionExpression(), executionContext);
			if (result == null) {
				throw new RuntimeException("decision expression '" + decisionNode.getDecisionExpression() + "' returned null");
			}
			transitionName = result.toString();
		} else {
			Iterator iter = decisionNode.getDecisionConditions().iterator();
			while (iter.hasNext() && (transitionName == null)) {
				DecisionCondition decisionCondition = (DecisionCondition) iter.next();
				Object result = JbpmExpressionEvaluator.evaluate(decisionCondition.getExpression(), executionContext);
				if (Boolean.TRUE.equals(result)) {
					transitionName = decisionCondition.getTransitionName();
				}
			}
			if (transitionName == null) {
				transitionName = decisionNode.getDefaultLeavingTransition().getName();
			}
		}
		return transitionName;
	}
	
	public DecisionSimulationData getSimulationData() {
		DecisionSimulationData result = null;
		if (!(simulationConfig.getSimulationData() instanceof DecisionSimulationData)) {
			result = new DecisionSimulationData(simulationConfig.getSimulationData());
		} else {
			result = (DecisionSimulationData) simulationConfig.getSimulationData();
		}
		simulationConfig.setSimulationData(result);
		return result;
	}

	@Override
	public List<Transition> getLeavingTransitions() {
		return leavingTransitions;
	}

	@Override
	public boolean fail() {
		// Decision nodes doesn't fail
		return false;
	}
	
	@Override
	public Collection<VariableAccess> getVariables() {
		// Decision nodes doesn't affect variables 
		return Collections.emptyList();
	}

}
