package com.tandbergtv.watchpoint.studio.debugger.ui;

import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.graphics.Image;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;

public class VariableExpressionValuesTableLabelProvider extends VariableValuesTableLabelProvider {

    private Image getImage(String fieldDecorationId) {
        FieldDecoration dec = FieldDecorationRegistry.getDefault().getFieldDecoration(fieldDecorationId);
        return dec.getImage();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        WPVariable model = (WPVariable) element;
        switch (columnIndex) {
        case 2:
            if (model.getError() != null && ((Object[]) model.getError())[0].equals(Boolean.TRUE)) {
                return getImage(FieldDecorationRegistry.DEC_ERROR);
            }  else if (model.isWritable()) {
                return getImage(FieldDecorationRegistry.DEC_CONTENT_PROPOSAL);
            }
        }
        return null;
    }
}