/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.interpreterwrapper;

import com.tandbergtv.watchpoint.studio.debugger.runtime.debug.Commands;
import com.tandbergtv.watchpoint.studio.interpreterwrapper.EventDispatcher;
import com.tandbergtv.watchpoint.studio.interpreterwrapper.IRuntimeCommandFacade;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.driver.DriverException;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Node;

public class RuntimeCommandFacade
implements IRuntimeCommandFacade {
    private EventDispatcher dispatcher;
    private Logger logger = Logger.getLogger(RuntimeCommandFacade.class);
    private String presentationTemplateFile;

    public RuntimeCommandFacade(String presentationTemplateFile, EventDispatcher dispatcher) {
        this.presentationTemplateFile = presentationTemplateFile;
        this.dispatcher = dispatcher;
    }

    private void treatException(Exception e) {
        this.dispatcher.aborted(e.getMessage());
    }

    @Override
    public void clear(String nodeName) {
        this.logger.debug((Object)("Command request received: CLEAR " + nodeName));
        WorkflowProcess process = Commands.find();
        Node node = Commands.findNode(process.getProcessDefinition(), nodeName);
        if (node == null) {
            this.logger.warn((Object)("Cannot remove breakpoint at " + nodeName));
            return;
        }
        Commands.removeBreakpoint(process, node);
    }

    @Override
    public void resume() {
        try {
            this.logger.debug((Object)"Command request received: RESUME");
            WorkflowProcess process = Commands.find();
            Commands.resume(process);
        }
        catch (DriverException e) {
            this.treatException((Exception)((Object)e));
        }
    }

    @Override
    public void set(String nodeName) {
        this.logger.debug((Object)("Command request received: SET " + nodeName));
        WorkflowProcess process = Commands.find();
        Node node = Commands.findNode(process.getProcessDefinition(), nodeName);
        if (node == null) {
            this.logger.warn((Object)("Cannot set breakpoint at " + nodeName));
            return;
        }
        Commands.addBreakpoint(process, node);
    }

    @Override
    public void suspend() {
        this.logger.debug((Object)"Command request received: SUSPEND ");
        WorkflowProcess process = Commands.find();
        Commands.suspend(process);
    }

    @Override
    public String getStack() {
        StringBuilder result = new StringBuilder();
        WorkflowProcess process = Commands.find();
        result.append(this.presentationTemplateFile);
        result.append("|");
        result.append(process.getProcessDefinition().getName());
        result.append("|");
        result.append(process.getRootToken().getCurrentNode().getName());
        for (Object key : process.getContextInstance().getVariables().keySet()) {
            result.append("|");
            result.append(process.getContextInstance().getVariables().get(key).getClass().getName());
            result.append("|");
            result.append(key);
        }
        this.logger.debug((Object)("Command request received: STACK - " + result.toString()));
        return result.toString();
    }

    @Override
    public String getVar(String name) {
        WorkflowProcess process = Commands.find();
        return process.getContextInstance().getVariable(name).getClass().getName() + "|" + process.getContextInstance().getVariable(name);
    }
}

