/**
 * 
 */
package com.tandbergtv.watchpoint.studio.debugger.core;

import static java.lang.Boolean.FALSE;
import static java.lang.Boolean.TRUE;

import java.text.ParseException;
import java.text.SimpleDateFormat;

/**
 * A list of data types for template variables.
 * 
 * @author Imran Naqvi
 */
public enum DataType {
	INT() {
		@Override
		public boolean match(String value) {
			try {
				Integer.parseInt(value);
				return true;
			} catch (NumberFormatException e) { return false; }
		}
	},
	STRING,
	BOOLEAN {
		@Override
		public boolean match(String value) {
			return TRUE.toString().equalsIgnoreCase(value) || FALSE.toString().equalsIgnoreCase(value);
		}
	},
	DATE {
		@Override
		public boolean match(String value) {
			try {
				new SimpleDateFormat("yyyy-MM-dd").parse(value);
				return true;
			} catch (ParseException e) { return false; }
		}
	},
	FILE,
	DURATION {
		@Override
		public boolean match(String value) {
			try {
				new SimpleDateFormat("HH:mm:ss").parse(value);
				return true;
			} catch (ParseException e) { return false; }
		}
	},
	URL,
	LIST;
	
	public boolean match(String value) {
		return true;
	}
}
