package com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation;

import java.util.Collection;
import java.util.Collections;

import org.jbpm.context.def.VariableAccess;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.node.TaskNode;
import org.jbpm.instantiation.FieldInstantiator;
import org.jbpm.instantiation.Instantiator;

import com.tandbergtv.watchpoint.studio.debugger.model.SimulationType;
import com.tandbergtv.watchpoint.studio.debugger.runtime.exception.NodeSimulationException;

/**
 * 		
 * @author <a href="mailto:francisco.bento.silva.neto@ericsson.com">efrasio - Francisco Bento da Silva Neto</a>
 *
 */
public class AutomaticTaskNodeSimulator extends AbstractMessageNodeSimulator {

	protected Collection<VariableAccess> variables = null;
	
	@Override
	public void simulate() throws Exception {
		if (SimulationType.EXECUTE.equals(simulationConfig.getSimulationType())) {
			TaskNode taskNode = (TaskNode) node;
			String className = taskNode.getAction().getActionDelegation().getClassName();
			try {
				Instantiator instantiator = new FieldInstantiator();
				Class<?> actionClass = Class.forName(className);
				String configuration = taskNode.getAction().getActionDelegation().getConfiguration();
				ActionHandler actionHandler = (ActionHandler) instantiator.instantiate(actionClass, configuration);
				actionHandler.execute(executionContext);
			} catch (Exception e) {
				String msg = "Error while invoking class: " + className;
				throw new NodeSimulationException(msg, node, this, e);
			} 
		}
	}
	  
	@Override
	public Collection<VariableAccess> getVariables() {
		return Collections.emptyList();
	}

}
