package com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation;

import java.util.Collection;
import java.util.Collections;

import org.jbpm.context.def.VariableAccess;
import org.jbpm.graph.node.StartState;

import com.tandbergtv.watchpoint.studio.debugger.core.DatatypeConverter;
import com.tandbergtv.watchpoint.studio.debugger.core.TypeConversionException;
import com.tandbergtv.watchpoint.studio.debugger.core.VariableAccess2;
import com.tandbergtv.watchpoint.studio.debugger.model.ParameterizableSimulationData;
import com.tandbergtv.watchpoint.studio.debugger.runtime.exception.NodeSimulationException;

/**
 * 		
 * @author <a href="mailto:francisco.bento.silva.neto@ericsson.com">efrasio - Francisco Bento da Silva Neto</a>
 *
 */
public class StartStateNodeSimulator extends AbstractMessageNodeSimulator {

	protected Collection<VariableAccess> variables = null;
	
	@Override
	public void simulate() throws Exception {
		ParameterizableSimulationData simulationData = getSimulationData();
		DatatypeConverter converter = new DatatypeConverter();
		for (VariableAccess var : getVariables()) {
			VariableAccess2 taskVar = (VariableAccess2) var;
			Object value = null;
			try {
				Object storedValue = simulationData.getVariable(var.getVariableName());
				if (storedValue != null && !"".equals(storedValue)) {
					value = converter.convert(storedValue, taskVar.getDatatype());					
				}
			} catch (TypeConversionException e) {
				String msg = "Error converting types. Please, verify the data type for the variable: " + var.getVariableName();
				throw new NodeSimulationException(msg, node, this, e);
			}
			executionContext.setVariable(var.getVariableName(), value);
		}
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public Collection<VariableAccess> getVariables() {
		if (variables == null) {
			StartState startState = (StartState) node;
			variables = Collections.emptyList();
			if (startState.getProcessDefinition().getTaskMgmtDefinition().getStartTask() != null) {
				variables = startState.getProcessDefinition().getTaskMgmtDefinition().getStartTask().getTaskController().getVariableAccesses();
			}
		}
		return variables;
	}

}
