package com.tandbergtv.watchpoint.studio.debugger.ui;

import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.jbpm.gd.common.model.GenericElement;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.ProcessState;

import com.tandbergtv.watchpoint.studio.debugger.model.NodeSimulationConfig;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.LoopNode;
import com.tandbergtv.watchpoint.studio.ui.model.MailNode;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.NodeGroup;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

/**
 * Label provider for the TemplateNodesTable
 * 
 * @author <a href="mailto:francisco.bento.silva.neto@ericsson.com">efrasio - Francisco Bento da Silva Neto</a>
 *
 */
public class NodeSimulationTableLabelProvider extends LabelProvider implements ITableLabelProvider {

	// Names of images used to represent checkboxes
	public static final String CHECKED_IMAGE 	= "checked.gif";
	public static final String UNCHECKED_IMAGE  = "unchecked.gif";

	// For the checkbox images
	private static ImageRegistry imageRegistry = new ImageRegistry();
	
	/**
	 * Note: An image registry owns all of the image objects registered with it,
	 * and automatically disposes of them WHEN the SWT Display is disposed.
	 */ 
	static {
		imageRegistry.put(CHECKED_IMAGE, Utility.getImageDescriptor(CHECKED_IMAGE));
		imageRegistry.put(UNCHECKED_IMAGE, Utility.getImageDescriptor(UNCHECKED_IMAGE));
	}
	/**
	 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(java.lang.Object, int)
	 */
	public String getColumnText(Object element, int columnIndex) {
		String result = null;
		NodeSimulationConfig nodeSimulation = (NodeSimulationConfig) element;
		switch (columnIndex) {
			case 0 : // NODE TYPE
				result = nodeSimulation.getNodeElement().getLabel();
				if (nodeSimulation.getNodeElement() instanceof NodeDefinition) {
					NodeDefinition nodeDefinition = (NodeDefinition) nodeSimulation.getNodeElement();
					if (nodeDefinition.getNode() instanceof NodeGroup) {
						result = nodeDefinition.getNode().getLabel();
					}
				}
				break;
			case 1 : // NODE NAME 
				result = nodeSimulation.getNodeElement().getName();					
				break;
			case 2 : // NODE DATA 
				result = getNodeSpecificData(nodeSimulation.getNodeElement());					
				break;
			case 3 : // SIMULATION TYPE
				if (nodeSimulation.getSimulationType() != null) {
					result = nodeSimulation.getSimulationType().getLabel();
				} else {
					result = "";
				}
				break;
			case 4 : // SKIP
				result = "";
				break;
			default :
				result = "";
		}
		return result;
	}
	
	protected String getNodeSpecificData(NodeElement nodeElement) {
		String result = "";
		if (nodeElement instanceof NodeDefinition) {
			result = getNodeSpecificData((NodeDefinition) nodeElement);
		} else if (nodeElement instanceof AutomaticTaskNode) {
			result = getNodeSpecificData((AutomaticTaskNode) nodeElement);
		} else if (nodeElement instanceof Decision) {
			result = getNodeSpecificData((Decision) nodeElement);
		} else if (nodeElement instanceof ProcessState) {
			result = getNodeSpecificData((ProcessState) nodeElement);
		} else if (nodeElement instanceof LoopNode) {
			result = getNodeSpecificData((LoopNode) nodeElement);
		} else if (nodeElement instanceof MailNode) {
			result = getNodeSpecificData((MailNode) nodeElement);
		}
		
		
		return result;
	}
	
	protected String getNodeSpecificData(NodeDefinition nodeDefinition) {
		String result = nodeDefinition.getDefinitionName();
		if (nodeDefinition.getNode() instanceof AutomaticTaskNode) {
			AutomaticTaskNode automaticNode = (AutomaticTaskNode) nodeDefinition.getNode();
			Action actionNode = automaticNode.getAction();
			GenericElement ge = actionNode.getGenericElements()[0];
			String messageUID = ge.getValue();
			
			IResourceTypeService service = ServiceFactory.createFactory().createResourceTypeService();
			Message message = service.findMessageByUID(messageUID);
			if (message != null) {
				result = message.getResourceType().getName() + "." + message.getName();
			}
		} else if (nodeDefinition.getNode() != null) {
			NodeGroup group = (NodeGroup) nodeDefinition.getNode();
			for (NodeElement ssElement : group.getNodeElements()) {
				if (ssElement instanceof NodeDefinition) {
					NodeDefinition nd = (NodeDefinition) ssElement;
					
					IResourceTypeService service = ServiceFactory.createFactory().createResourceTypeService();
					Message message = service.findMessageByUID(nd.getUid());
					if (message != null) {
						result = message.getResourceType().getName() + "." + result;
					}
					break;
				}
			}
		}
		return result;
	}
	
	protected String getNodeSpecificData(Decision decision) {
		String result = decision.getExpression();
		return result;
	}
	
	protected String getNodeSpecificData(LoopNode loop) {
		String result = loop.getExpression();
		return result;
	}
	
	protected String getNodeSpecificData(ProcessState process) {
		String result = process.getSubProcess().getName();
		return result;
	}
	
	protected String getNodeSpecificData(MailNode mail) {
		String subject = "";
		if (mail.getSubject() != null) {
			subject = mail.getSubject().getSubject();
			if (subject == null) {
				subject = "";
			}
		}
		String result = "To: " + mail.getTo() + " Subject: " + subject;
		return result;
	}
	
	protected String getNodeSpecificData(AutomaticTaskNode automaticNode) {
		Action actionNode = automaticNode.getAction();
		return actionNode.getClassName();
	}

	/**
	 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(java.lang.Object, int)
	 */
	public Image getColumnImage(Object element, int columnIndex) {
		Image image = null;
		return image;
	}

}

