package com.tandbergtv.watchpoint.studio.builder.resolution.template;

import static com.tandbergtv.watchpoint.studio.ui.model.SemanticElementConstants.VARIABLE_SEID;

import org.eclipse.core.resources.IResource;
import org.jbpm.gd.jpdl.model.StartState;

import com.tandbergtv.watchpoint.studio.builder.resolution.ResolutionMessages;
import com.tandbergtv.watchpoint.studio.ui.model.LoopNode;
import com.tandbergtv.watchpoint.studio.ui.model.LoopNodeType;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.properties.DataType;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

public class LoopNodeWithoutIndexResolution extends WatchpointStudioTemplateResolution {

    public LoopNodeWithoutIndexResolution(IResource resource, Object element) {
        super(resource, element, null);
    }

    @Override
    public String getLabel() {
        return ResolutionMessages.VMC_LN_007;
    }

    @Override
    public void run() {
        try {
            WorkflowTemplate template = getTemplate();

            String variableName = calculateNewVariableName(template, "loopIndex");
            template.getStartState().getTask().getController().addVariable(createIntVar(template.getStartState(), variableName));

            LoopNode ln = (LoopNode) template.getNodeElementByName((String) element);
            ln.setIndex(variableName);
            if (LoopNodeType.FOR_EACH.equals(ln.getLoopType()) && ln.getListName() != null && !ln.getListName().isEmpty()) {
                ln.setExpression(new StringBuilder().append(ln.getListName()).append("[").append(variableName).append("] != null").toString());
            } else if (LoopNodeType.WHILE.equals(ln.getLoopType())) {
                ln.setExpression(variableName + " < ");
            } else if (LoopNodeType.FOR.equals(ln.getLoopType())) {
                ln.setExpression(new StringBuilder(variableName).append(" < ").append(ln.getFinalValue() > -1 ? ln.getFinalValue() : 0).toString());
            }

            saveTemplate();

        } catch (Exception e) {
            Utility.reportError("Error while removing unused variable.", e);
        }
    }

    private WPVariable createIntVar(StartState startState, String variableName) {
        WPVariable newIntVariable = (WPVariable) startState.getFactory().createById(VARIABLE_SEID);
        newIntVariable.setType(DataType.INT.toString());
        newIntVariable.setAccess("read,write");
        newIntVariable.setValue("0");
        newIntVariable.setName(variableName);
        newIntVariable.setMappedName(variableName);
        return newIntVariable;
    }
}
